use App\Http\Controllers\OrderController;
Route::middleware(['web', 'auth'])->group(function () {
    Route::get('/orders', [OrderController::class, 'index'])->name('order.index');
    Route::post('/orders', [OrderController::class, 'store'])->name('order.store');
});
use App\Http\Controllers\CartController;
Route::middleware(['web', 'auth'])->group(function () {
    Route::get('/cart', [CartController::class, 'index'])->name('cart.index');
    Route::post('/cart/add/{productId}', [CartController::class, 'add'])->name('cart.add');
    Route::delete('/cart/remove/{id}', [CartController::class, 'remove'])->name('cart.remove');
});
use App\Http\Controllers\ProductController;
Route::get('/products', [ProductController::class, 'index'])->name('product.index');
Route::get('/products/{id}', [ProductController::class, 'show'])->name('product.show');
use App\Http\Controllers\FranchiseController;
Route::middleware(['web', 'auth'])->group(function () {
    Route::resource('franchise', FranchiseController::class);
});
use App\Http\Controllers\Auth\VerificationController;
Route::middleware(['auth', 'web'])->group(function () {
    Route::get('/email/verify', [VerificationController::class, 'show'])->name('verification.notice');
    Route::get('/email/verify/{id}/{hash}', [VerificationController::class, 'verify'])->middleware('signed')->name('verification.verify');
    Route::post('/email/verification-notification', [VerificationController::class, 'resend'])->name('verification.send');
});
use App\Http\Controllers\Auth\ForgotPasswordController;
Route::get('/password/reset', [ForgotPasswordController::class, 'showLinkRequestForm'])->name('password.request');
Route::post('/password/email', [ForgotPasswordController::class, 'sendResetLinkEmail'])->name('password.email');
use App\Http\Controllers\Auth\RegisterController;
Route::get('/register', [RegisterController::class, 'showRegistrationForm'])->name('register');
Route::post('/register', [RegisterController::class, 'register']);
<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Install\InstallerController;
use App\Http\Controllers\HomeController;


use App\Http\Controllers\DashboardController;

Route::get('/', [HomeController::class, 'index'])->name('home');

use App\Http\Controllers\InventoryController;
use App\Http\Controllers\EPinController;
    // 2FA routes
    Route::get('/2fa', [TwoFactorController::class, 'show2faForm'])->name('2fa.form');
    Route::post('/2fa', [TwoFactorController::class, 'verify2fa'])->name('2fa.verify');
    Route::get('/2fa/setup', [TwoFactorController::class, 'setupForm'])->name('2fa.setup');
    Route::post('/2fa/setup', [TwoFactorController::class, 'setup'])->name('2fa.setup.submit');
    Route::post('/2fa/disable', [TwoFactorController::class, 'disable'])->name('2fa.disable');
use App\Http\Controllers\KYCController;
use App\Http\Controllers\ReportController;
use App\Http\Controllers\WithdrawalController;
use App\Http\Controllers\AdminDashboardController;
use App\Http\Controllers\UserProfileController;
use App\Http\Controllers\NotificationController;
use App\Http\Controllers\RBACController;
use App\Http\Controllers\GDPRController;
use App\Http\Controllers\BulkImportExportController;
Route::middleware(['web', 'auth'])->group(function () {
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');
    Route::resource('inventory', InventoryController::class)->except(['show']);
    Route::resource('epin', EPinController::class)->except(['show']);
    Route::resource('kyc', KYCController::class)->except(['show']);
    Route::get('/report/income', [ReportController::class, 'income'])->name('report.income');
    Route::get('/report/commission', [ReportController::class, 'commission'])->name('report.commission');
    Route::get('/report/payout', [ReportController::class, 'payout'])->name('report.payout');
    Route::resource('withdrawal', WithdrawalController::class)->except(['show']);
    Route::get('/admin/dashboard', [AdminDashboardController::class, 'index'])->name('admin.dashboard');
    Route::get('/admin/settings', [AdminDashboardController::class, 'settings'])->name('admin.settings');
    Route::post('/admin/settings', [AdminDashboardController::class, 'updateSettings'])->name('admin.settings.update');
    Route::get('/user/profile', [UserProfileController::class, 'edit'])->name('user.profile.edit');
    Route::post('/user/profile', [UserProfileController::class, 'update'])->name('user.profile.update');
    Route::get('/notification/send', [NotificationController::class, 'form'])->name('notification.form');
    Route::post('/notification/send', [NotificationController::class, 'send'])->name('notification.send');
    Route::get('/rbac/roles', [RBACController::class, 'roles'])->name('rbac.roles');
    Route::get('/rbac/permissions', [RBACController::class, 'permissions'])->name('rbac.permissions');
    Route::post('/rbac/assign-role', [RBACController::class, 'assignRole'])->name('rbac.assignRole');
    Route::post('/rbac/assign-permission', [RBACController::class, 'assignPermission'])->name('rbac.assignPermission');
    Route::get('/auditlog', [AuditLogController::class, 'index'])->name('auditlog.index');
    Route::get('/privacy', [GDPRController::class, 'privacy'])->name('gdpr.privacy');
    Route::post('/privacy/download', [GDPRController::class, 'downloadData'])->name('gdpr.download');
    Route::post('/privacy/delete', [GDPRController::class, 'deleteAccount'])->name('gdpr.delete');
    // Bulk import/export
    Route::get('/bulk/import-export', [BulkImportExportController::class, 'show'])->name('bulk.import_export');
    Route::post('/bulk/export/products', [BulkImportExportController::class, 'exportProducts'])->name('bulk.export.products');
    Route::post('/bulk/import/products', [BulkImportExportController::class, 'importProducts'])->name('bulk.import.products');
    Route::post('/bulk/export/users', [BulkImportExportController::class, 'exportUsers'])->name('bulk.export.users');
    Route::post('/bulk/import/users', [BulkImportExportController::class, 'importUsers'])->name('bulk.import.users');
});

Route::group(['prefix' => 'install', 'middleware' => 'web'], function () {
    Route::get('/', [InstallerController::class, 'index'])->name('install.index');
    Route::post('requirements', [InstallerController::class, 'requirements'])->name('install.requirements');
    Route::post('permissions', [InstallerController::class, 'permissions'])->name('install.permissions');
    Route::post('database', [InstallerController::class, 'database'])->name('install.database');
    Route::post('env', [InstallerController::class, 'env'])->name('install.env');
    Route::post('migrate', [InstallerController::class, 'migrate'])->name('install.migrate');
    Route::post('seed', [InstallerController::class, 'seed'])->name('install.seed');
    Route::post('key', [InstallerController::class, 'key'])->name('install.key');
    Route::post('storage', [InstallerController::class, 'storage'])->name('install.storage');
    Route::post('lock', [InstallerController::class, 'lock'])->name('install.lock');
    Route::get('cron', [InstallerController::class, 'cron'])->name('install.cron');
    Route::get('finish', [InstallerController::class, 'finish'])->name('install.finish');
});
