<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\UserController;
use App\Http\Controllers\Api\WalletController;
use App\Http\Controllers\Api\LedgerController;

Route::middleware(['api', 'auth:sanctum'])->group(function () {
    Route::get('/user/profile', [UserController::class, 'profile']);
    Route::get('/user/{id}', [UserController::class, 'show']);
    Route::get('/wallets', [WalletController::class, 'index']);
    Route::get('/ledger', [LedgerController::class, 'index']);
    // Franchise
    Route::apiResource('franchise', 'App\\Http\\Controllers\\FranchiseController');
    // Product
    Route::apiResource('product', 'App\\Http\\Controllers\\ProductController');
    // Cart
    Route::apiResource('cart', 'App\\Http\\Controllers\\CartController');
    // Order
    Route::apiResource('order', 'App\\Http\\Controllers\\OrderController');
    // Inventory
    Route::apiResource('inventory', 'App\\Http\\Controllers\\InventoryController');
    // EPin
    Route::apiResource('epin', 'App\\Http\\Controllers\\EPinController');
    // KYC
    Route::apiResource('kyc', 'App\\Http\\Controllers\\KYCController');
    // Report
    Route::get('/report/income', 'App\\Http\\Controllers\\ReportController@income');
    Route::get('/report/commission', 'App\\Http\\Controllers\\ReportController@commission');
    Route::get('/report/payout', 'App\\Http\\Controllers\\ReportController@payout');
    // Withdrawal
    Route::apiResource('withdrawal', 'App\\Http\\Controllers\\WithdrawalController');
    // Admin
    Route::get('/admin/dashboard', 'App\\Http\\Controllers\\AdminDashboardController@index');
    Route::get('/admin/settings', 'App\\Http\\Controllers\\AdminDashboardController@settings');
    Route::post('/admin/settings', 'App\\Http\\Controllers\\AdminDashboardController@updateSettings');
    // User profile
    Route::get('/user/profile/edit', 'App\\Http\\Controllers\\UserProfileController@edit');
    Route::post('/user/profile/update', 'App\\Http\\Controllers\\UserProfileController@update');
    // Notification
    Route::post('/notification/send', 'App\\Http\\Controllers\\NotificationController@send');
});
