@extends('dashboard.index')
@section('content')
<div class="container">
    <h2>Withdrawal Requests</h2>
    <a href="{{ route('withdrawal.create') }}" class="btn btn-primary mb-3">Request Withdrawal</a>
    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif
    <table class="table table-bordered">
        <thead>
            <tr>
                <th>ID</th>
                <th>User</th>
                <th>Wallet</th>
                <th>Amount</th>
                <th>Status</th>
                <th>Date</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            @foreach($requests as $req)
            <tr>
                <td>{{ $req->id }}</td>
                <td>{{ $req->user_id }}</td>
                <td>{{ $req->wallet_id }}</td>
                <td>{{ $req->amount }}</td>
                <td>{{ $req->status }}</td>
                <td>{{ $req->created_at }}</td>
                <td>
                    <a href="{{ route('withdrawal.edit', $req) }}" class="btn btn-sm btn-warning">Review</a>
                    <form action="{{ route('withdrawal.destroy', $req) }}" method="POST" style="display:inline;">
                        @csrf @method('DELETE')
                        <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Delete?')">Delete</button>
                    </form>
                </td>
            </tr>
            @endforeach
        </tbody>
    </table>
    {{ $requests->links() }}
</div>
@endsection
