@extends('dashboard.index')
@section('content')
<div class="container">
    <h2>Review Withdrawal Request</h2>
    <form method="POST" action="{{ route('withdrawal.update', $withdrawal) }}">
        @csrf
        @method('PUT')
        <div class="mb-3">
            <label>Status</label>
            <select name="status" class="form-control" required>
                <option value="pending" @if($withdrawal->status=='pending') selected @endif>Pending</option>
                <option value="approved" @if($withdrawal->status=='approved') selected @endif>Approved</option>
                <option value="rejected" @if($withdrawal->status=='rejected') selected @endif>Rejected</option>
            </select>
        </div>
        <button type="submit" class="btn btn-primary">Update</button>
        <a href="{{ route('withdrawal.index') }}" class="btn btn-secondary">Cancel</a>
    </form>
</div>
@endsection
