@extends('dashboard.index')
@section('content')
<div class="container">
    <h2>Send Notification</h2>
    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif
    <form method="POST" action="{{ route('notification.send') }}">
        @csrf
        <div class="mb-3">
            <label>Type</label>
            <select name="type" class="form-control" required>
                <option value="email">Email</option>
                <option value="sms">SMS</option>
                <option value="whatsapp">WhatsApp</option>
            </select>
        </div>
        <div class="mb-3">
            <label>To</label>
            <input type="text" name="to" class="form-control" required>
        </div>
        <div class="mb-3">
            <label>Subject (Email only)</label>
            <input type="text" name="subject" class="form-control">
        </div>
        <div class="mb-3">
            <label>Message</label>
            <textarea name="message" class="form-control" required></textarea>
        </div>
        <button type="submit" class="btn btn-primary">Send</button>
    </form>
</div>
@endsection
