@extends('dashboard.index')
@section('content')
<div class="container">
    <h2>KYC Documents</h2>
    <a href="{{ route('kyc.create') }}" class="btn btn-primary mb-3">Upload KYC</a>
    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif
    <table class="table table-bordered">
        <thead>
            <tr>
                <th>ID</th>
                <th>User</th>
                <th>Type</th>
                <th>File</th>
                <th>Status</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            @foreach($kycs as $kyc)
            <tr>
                <td>{{ $kyc->id }}</td>
                <td>{{ $kyc->user_id }}</td>
                <td>{{ $kyc->document_type }}</td>
                <td><a href="{{ Storage::url($kyc->document_file) }}" target="_blank">View</a></td>
                <td>{{ $kyc->status }}</td>
                <td>
                    <a href="{{ route('kyc.edit', $kyc) }}" class="btn btn-sm btn-warning">Review</a>
                    <form action="{{ route('kyc.destroy', $kyc) }}" method="POST" style="display:inline;">
                        @csrf @method('DELETE')
                        <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Delete?')">Delete</button>
                    </form>
                </td>
            </tr>
            @endforeach
        </tbody>
    </table>
    {{ $kycs->links() }}
</div>
@endsection
