@extends('dashboard.index')
@section('content')
<div class="container">
    <h2>Inventory List</h2>
    <a href="{{ route('inventory.create') }}" class="btn btn-primary mb-3">Add Inventory</a>
    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif
    <table class="table table-bordered">
        <thead>
            <tr>
                <th>ID</th>
                <th>Warehouse</th>
                <th>Product</th>
                <th>Quantity</th>
                <th>Reserved</th>
                <th>Min Stock</th>
                <th>Max Stock</th>
                <th>Last Restocked</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            @foreach($inventories as $inv)
            <tr>
                <td>{{ $inv->id }}</td>
                <td>{{ $inv->warehouse->name ?? '-' }}</td>
                <td>{{ $inv->product->name ?? '-' }}</td>
                <td>{{ $inv->quantity }}</td>
                <td>{{ $inv->reserved }}</td>
                <td>{{ $inv->min_stock }}</td>
                <td>{{ $inv->max_stock }}</td>
                <td>{{ $inv->last_restocked_at }}</td>
                <td>
                    <a href="{{ route('inventory.edit', $inv) }}" class="btn btn-sm btn-warning">Edit</a>
                    <form action="{{ route('inventory.destroy', $inv) }}" method="POST" style="display:inline;">
                        @csrf @method('DELETE')
                        <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Delete?')">Delete</button>
                    </form>
                </td>
            </tr>
            @endforeach
        </tbody>
    </table>
    {{ $inventories->links() }}
</div>
@endsection
