@extends('dashboard.index')
@section('content')
<div class="container">
    <h2>Edit Inventory</h2>
    <form method="POST" action="{{ route('inventory.update', $inventory) }}">
        @csrf
        @method('PUT')
        <div class="mb-3">
            <label>Warehouse</label>
            <select name="warehouse_id" class="form-control" required>
                @foreach($warehouses as $w)
                    <option value="{{ $w->id }}" @if($inventory->warehouse_id == $w->id) selected @endif>{{ $w->name }}</option>
                @endforeach
            </select>
        </div>
        <div class="mb-3">
            <label>Product</label>
            <select name="product_id" class="form-control" required>
                @foreach($products as $p)
                    <option value="{{ $p->id }}" @if($inventory->product_id == $p->id) selected @endif>{{ $p->name }}</option>
                @endforeach
            </select>
        </div>
        <div class="mb-3">
            <label>Quantity</label>
            <input type="number" name="quantity" class="form-control" value="{{ $inventory->quantity }}" required>
        </div>
        <div class="mb-3">
            <label>Min Stock</label>
            <input type="number" name="min_stock" class="form-control" value="{{ $inventory->min_stock }}">
        </div>
        <div class="mb-3">
            <label>Max Stock</label>
            <input type="number" name="max_stock" class="form-control" value="{{ $inventory->max_stock }}">
        </div>
        <button type="submit" class="btn btn-primary">Update</button>
        <a href="{{ route('inventory.index') }}" class="btn btn-secondary">Cancel</a>
    </form>
</div>
@endsection
