<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>AKRSera MLM Installer</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css">
</head>
<body class="bg-light">
<div class="container py-5">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card shadow">
                <div class="card-header bg-primary text-white">
                    <h3 class="mb-0">AKRSera MLM Installer</h3>
                </div>
                <div class="card-body">
                    <div id="install-steps">
                        <!-- Vue/JSX/Alpine or plain JS can be used for wizard steps -->
                        <p>Welcome to the AKRSera MLM Installer.<br>Follow the steps to complete installation.</p>
                        <ol>
                            <li>Server Requirement Check</li>
                            <li>Folder Permission Check</li>
                            <li>Database Configuration</li>
                            <li>Write .env</li>
                            <li>Reload Config</li>
                            <li>Migrate</li>
                            <li>Seed Admin + Company</li>
                            <li>Generate App Key</li>
                            <li>Create Storage Link Fallback Copy</li>
                            <li>Lock Installer</li>
                            <li>Show Cron Commands</li>
                            <li>Redirect Login</li>
                        </ol>
                        <div class="alert alert-info mt-3">Installer will block /install forever after success.</div>
                    </div>
                    <form id="installer-form" method="POST" action="/install/database">
                        <!-- Add JS logic for step-by-step wizard -->
                        <button type="submit" class="btn btn-primary">Start Installation</button>
                    </form>
                </div>
                <div class="card-footer text-center small text-muted">
                    Made by AKRS WORLD | Powered by AKRSera Technologies Pvt. Ltd.
                </div>
            </div>
        </div>
    </div>
</div>
</body>
</html>
