<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Franchises | AKRSera MLM</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css">
</head>
<body class="bg-light">
<div class="container py-5">
    <div class="row mb-4">
        <div class="col-12 d-flex justify-content-between align-items-center">
            <h2>Franchises</h2>
            <a href="{{ route('franchise.create') }}" class="btn btn-primary">Add Franchise</a>
        </div>
    </div>
    <div class="row">
        <div class="col-12">
            <table class="table table-bordered">
                <thead>
                    <tr>
                        <th>Name</th>
                        <th>Code</th>
                        <th>Email</th>
                        <th>Phone</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($franchises as $franchise)
                        <tr>
                            <td>{{ $franchise->name }}</td>
                            <td>{{ $franchise->code }}</td>
                            <td>{{ $franchise->email }}</td>
                            <td>{{ $franchise->phone }}</td>
                            <td>
                                <a href="{{ route('franchise.edit', $franchise->id) }}" class="btn btn-sm btn-warning">Edit</a>
                                <form action="{{ route('franchise.destroy', $franchise->id) }}" method="POST" style="display:inline-block;">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-sm btn-danger">Delete</button>
                                </form>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>
</body>
</html>
