@extends('dashboard.index')
@section('content')
<div class="container">
    <h2>EPin List</h2>
    <a href="{{ route('epin.create') }}" class="btn btn-primary mb-3">Create EPin</a>
    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif
    <table class="table table-bordered">
        <thead>
            <tr>
                <th>ID</th>
                <th>Code</th>
                <th>Amount</th>
                <th>Status</th>
                <th>Expires At</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            @foreach($epins as $epin)
            <tr>
                <td>{{ $epin->id }}</td>
                <td>{{ $epin->code }}</td>
                <td>{{ $epin->amount }}</td>
                <td>{{ $epin->status }}</td>
                <td>{{ $epin->expires_at }}</td>
                <td>
                    <a href="{{ route('epin.edit', $epin) }}" class="btn btn-sm btn-warning">Edit</a>
                    <form action="{{ route('epin.destroy', $epin) }}" method="POST" style="display:inline;">
                        @csrf @method('DELETE')
                        <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Delete?')">Delete</button>
                    </form>
                </td>
            </tr>
            @endforeach
        </tbody>
    </table>
    {{ $epins->links() }}
</div>
@endsection
