@extends('dashboard.index')
@section('content')
<div class="container">
    <h2>Edit EPin</h2>
    <form method="POST" action="{{ route('epin.update', $epin) }}">
        @csrf
        @method('PUT')
        <div class="mb-3">
            <label>Amount</label>
            <input type="number" name="amount" class="form-control" value="{{ $epin->amount }}" required>
        </div>
        <div class="mb-3">
            <label>Expires At</label>
            <input type="date" name="expires_at" class="form-control" value="{{ $epin->expires_at }}">
        </div>
        <div class="mb-3">
            <label>Status</label>
            <select name="status" class="form-control" required>
                <option value="active" @if($epin->status=='active') selected @endif>Active</option>
                <option value="used" @if($epin->status=='used') selected @endif>Used</option>
                <option value="expired" @if($epin->status=='expired') selected @endif>Expired</option>
            </select>
        </div>
        <button type="submit" class="btn btn-primary">Update</button>
        <a href="{{ route('epin.index') }}" class="btn btn-secondary">Cancel</a>
    </form>
</div>
@endsection
