<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard | AKRSera MLM</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css">
</head>
<body class="bg-light">
<div class="container py-5">
    <div class="row mb-4">
        <div class="col-12 text-center">
            <h2>Welcome, {{ $user->first_name }}!</h2>
            <p class="text-muted">Fintech Dashboard | AKRSera MLM</p>
        </div>
    </div>
    <div class="row mb-4">
        <div class="col-md-3">
            <div class="card text-center">
                <div class="card-body">
                    <h5 class="card-title">Wallets</h5>
                    <ul class="list-group">
                        @foreach($wallets as $wallet)
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                {{ ucfirst($wallet->type) }}
                                <span class="badge bg-success">{{ number_format($wallet->balance, 2) }}</span>
                            </li>
                        @endforeach
                    </ul>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card text-center">
                <div class="card-body">
                    <h5 class="card-title">Team</h5>
                    <p class="display-6">{{ $teamCount }}</p>
                    <p class="text-muted">Direct Referrals</p>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card text-center">
                <div class="card-body">
                    <h5 class="card-title">Binary BV</h5>
                    <p>Left: <span class="badge bg-primary">{{ $stats['binary_bv']['left'] ?? 0 }}</span></p>
                    <p>Right: <span class="badge bg-primary">{{ $stats['binary_bv']['right'] ?? 0 }}</span></p>
                    <p>Pair: <span class="badge bg-success">{{ $stats['binary_bv']['pair'] ?? 0 }}</span></p>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card text-center">
                <div class="card-body">
                    <h5 class="card-title">Repurchase BV</h5>
                    <p class="display-6">{{ $stats['repurchase_bv'] ?? 0 }}</p>
                    <p class="text-muted">Total Repurchase BV</p>
                </div>
            </div>
        </div>
        <div class="col-md-6">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">Recent Ledger Entries</h5>
                    <table class="table table-sm">
                        <thead>
                        <tr>
                            <th>Date</th>
                            <th>Type</th>
                            <th>Amount</th>
                        </tr>
                        </thead>
                        <tbody>
                        @foreach($ledger as $entry)
                            <tr>
                                <td>{{ $entry->created_at->format('Y-m-d') }}</td>
                                <td>{{ ucfirst($entry->entry_type) }}</td>
                                <td>{{ number_format($entry->amount, 2) }}</td>
                            </tr>
                        @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-12 text-center small text-muted">
            Powered by AKRSera Technologies Pvt. Ltd.
        </div>
    </div>
</div>
</body>
</html>
