@extends('layouts.app')
@section('content')
<div class="container">
    <h2>Bulk Import/Export</h2>
    <div class="row">
        <div class="col-md-6">
            <h4>Export Products</h4>
            <form method="POST" action="{{ route('bulk.export.products') }}">
                @csrf
                <button type="submit" class="btn btn-primary">Export Products CSV</button>
            </form>
            <h4 class="mt-4">Import Products</h4>
            <form method="POST" action="{{ route('bulk.import.products') }}" enctype="multipart/form-data">
                @csrf
                <input type="file" name="file" accept=".csv,.txt" required class="form-control mb-2">
                <button type="submit" class="btn btn-success">Import Products CSV</button>
            </form>
        </div>
        <div class="col-md-6">
            <h4>Export Users</h4>
            <form method="POST" action="{{ route('bulk.export.users') }}">
                @csrf
                <button type="submit" class="btn btn-primary">Export Users CSV</button>
            </form>
            <h4 class="mt-4">Import Users</h4>
            <form method="POST" action="{{ route('bulk.import.users') }}" enctype="multipart/form-data">
                @csrf
                <input type="file" name="file" accept=".csv,.txt" required class="form-control mb-2">
                <button type="submit" class="btn btn-success">Import Users CSV</button>
            </form>
        </div>
    </div>
</div>
@endsection
