@extends('layouts.app')
@section('content')
<div class="container">
    <h2>Setup Two-Factor Authentication</h2>
    <form method="POST" action="{{ route('2fa.setup.submit') }}">
        @csrf
        <div class="mb-3">
            <label for="method" class="form-label">Choose Method</label>
            <select name="method" id="method" class="form-control" required onchange="showFields(this.value)">
                <option value="sms">SMS</option>
                <option value="email">Email</option>
                <option value="app">Authenticator App</option>
            </select>
        </div>
        <div class="mb-3" id="smsField" style="display:none;">
            <label for="phone_number" class="form-label">Phone Number</label>
            <input type="text" name="phone_number" class="form-control">
        </div>
        <div class="mb-3" id="emailField" style="display:none;">
            <label for="email" class="form-label">Email</label>
            <input type="email" name="email" class="form-control">
        </div>
        <div class="mb-3" id="appField" style="display:none;">
            <p>Scan QR code with your Authenticator app (coming soon).</p>
        </div>
        <button type="submit" class="btn btn-primary">Setup 2FA</button>
    </form>
    <form method="POST" action="{{ route('2fa.disable') }}" style="margin-top:20px;">
        @csrf
        <button type="submit" class="btn btn-danger">Disable 2FA</button>
    </form>
</div>
<script>
function showFields(method) {
    document.getElementById('smsField').style.display = method === 'sms' ? 'block' : 'none';
    document.getElementById('emailField').style.display = method === 'email' ? 'block' : 'none';
    document.getElementById('appField').style.display = method === 'app' ? 'block' : 'none';
}
</script>
@endsection
