<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\User;
use App\Models\Company;
use Illuminate\Support\Facades\Hash;

class AdminSeeder extends Seeder
{
    public function run()
    {
        $company = Company::firstOrCreate([
            'name' => 'AKRSera MLM',
            'slug' => 'akrsera',
            'email' => 'admin@akrsera.com',
        ], [
            'is_active' => true,
        ]);

        User::firstOrCreate([
            'username' => 'admin',
            'company_id' => $company->id,
        ], [
            'first_name' => 'Super',
            'last_name' => 'Admin',
            'email' => 'admin@akrsera.com',
            'phone' => '9999999999',
            'password' => Hash::make('admin@123'),
            'user_type' => 'distributor',
            'status' => 'active',
            'kyc_verified' => true,
        ]);
    }
}
