<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('products', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('company_id')->index();
            $table->string('name')->index();
            $table->string('sku')->unique();
            $table->text('description')->nullable();
            $table->enum('type', ['physical', 'digital', 'subscription'])->index();
            $table->decimal('cost_price', 18, 2);
            $table->decimal('sale_price', 18, 2)->index();
            $table->decimal('bv_value', 18, 2)->default(0);
            $table->string('hsn_code')->nullable();
            $table->decimal('gst_percentage', 5, 2)->default(0);
            $table->boolean('is_active')->default(true)->index();
            $table->unsignedInteger('stock_quantity')->default(0);
            $table->timestamps();

            $table->foreign('company_id')->references('id')->on('companies')->onDelete('cascade');
            $table->index(['company_id', 'type']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('products');
    }
};
