<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('e_pins', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('company_id')->index();
            $table->string('pin_code')->unique()->index();
            $table->enum('status', ['active', 'transferred', 'used', 'expired'])->default('active')->index();
            $table->unsignedBigInteger('generated_by')->index();
            $table->unsignedBigInteger('generated_for')->nullable()->index();
            $table->unsignedBigInteger('transferred_to')->nullable()->index();
            $table->unsignedBigInteger('used_by')->nullable()->index();
            $table->decimal('value', 18, 2)->default(0);
            $table->timestamp('generated_at')->nullable();
            $table->timestamp('transferred_at')->nullable();
            $table->timestamp('used_at')->nullable();
            $table->timestamp('expires_at')->nullable();
            $table->timestamps();

            $table->foreign('company_id')->references('id')->on('companies')->onDelete('cascade');
            $table->foreign('generated_by')->references('id')->on('users')->onDelete('cascade');
            $table->foreign('generated_for')->references('id')->on('users')->onDelete('set null');
            $table->foreign('transferred_to')->references('id')->on('users')->onDelete('set null');
            $table->foreign('used_by')->references('id')->on('users')->onDelete('set null');
            $table->index(['company_id', 'status']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('e_pins');
    }
};
