<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('two_factor_authentications', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('company_id')->index();
            $table->unsignedBigInteger('user_id')->unique()->index();
            $table->boolean('is_enabled')->default(false)->index();
            $table->string('phone_number')->nullable();
            $table->string('email')->nullable();
            $table->enum('method', ['sms', 'email', 'authenticator'])->nullable();
            $table->string('secret_key')->nullable();
            $table->string('backup_codes')->nullable();
            $table->text('trusted_devices')->nullable();
            $table->timestamp('enabled_at')->nullable();
            $table->timestamps();

            $table->foreign('company_id')->references('id')->on('companies')->onDelete('cascade');
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('two_factor_authentications');
    }
};
