<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('income_records', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('company_id')->index();
            $table->unsignedBigInteger('user_id')->index();
            $table->enum('income_type', [
                'direct', 'binary_pairing', 'level', 'generation', 'roi', 
                'rank', 'pool', 'reward', 'bonus', 'cashback'
            ])->index();
            $table->unsignedBigInteger('source_user_id')->nullable()->index();
            $table->decimal('amount', 18, 2)->index();
            $table->text('description')->nullable();
            $table->unsignedBigInteger('transaction_id')->nullable();
            $table->date('processing_date')->index();
            $table->timestamps();

            $table->foreign('company_id')->references('id')->on('companies')->onDelete('cascade');
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
            $table->foreign('source_user_id')->references('id')->on('users')->onDelete('set null');
            $table->foreign('transaction_id')->references('id')->on('transactions')->onDelete('set null');
            $table->index(['company_id', 'user_id', 'income_type']);
            $table->index(['processing_date']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('income_records');
    }
};
