<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('withdrawal_requests', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('company_id')->index();
            $table->unsignedBigInteger('user_id')->index();
            $table->enum('method', ['bank_transfer', 'upi', 'cheque', 'neft'])->index();
            $table->decimal('requested_amount', 18, 2)->index();
            $table->decimal('approved_amount', 18, 2)->nullable();
            $table->decimal('tds_deduction', 18, 2)->default(0);
            $table->decimal('service_charge', 18, 2)->default(0);
            $table->decimal('final_amount', 18, 2)->nullable();
            $table->enum('status', [
                'pending', 'approved', 'rejected', 'processing', 
                'completed', 'failed', 'cancelled'
            ])->default('pending')->index();
            $table->string('rejection_reason')->nullable();
            $table->text('admin_notes')->nullable();
            $table->string('transaction_reference')->nullable()->unique();
            $table->string('utr')->nullable();
            $table->timestamp('approved_at')->nullable();
            $table->unsignedBigInteger('approved_by')->nullable();
            $table->timestamp('processed_at')->nullable();
            $table->timestamp('completed_at')->nullable();
            $table->timestamp('cooldown_until')->nullable();
            $table->timestamps();

            $table->foreign('company_id')->references('id')->on('companies')->onDelete('cascade');
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
            $table->foreign('approved_by')->references('id')->on('users')->onDelete('set null');
            $table->index(['company_id', 'user_id', 'status']);
            $table->index(['created_at']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('withdrawal_requests');
    }
};
