<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('bv_records', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('company_id')->index();
            $table->unsignedBigInteger('user_id')->index();
            $table->date('record_date')->index();
            $table->decimal('self_bv', 18, 2)->default(0);
            $table->decimal('left_bv', 18, 2)->default(0);
            $table->decimal('right_bv', 18, 2)->default(0);
            $table->decimal('left_carry_forward', 18, 2)->default(0);
            $table->decimal('right_carry_forward', 18, 2)->default(0);
            $table->decimal('left_processed', 18, 2)->default(0);
            $table->decimal('right_processed', 18, 2)->default(0);
            $table->boolean('is_active')->default(true)->index();
            $table->timestamps();

            $table->foreign('company_id')->references('id')->on('companies')->onDelete('cascade');
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
            $table->unique(['company_id', 'user_id', 'record_date']);
            $table->index(['company_id', 'record_date']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('bv_records');
    }
};
