<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('closure_trees', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('company_id')->index();
            $table->unsignedBigInteger('ancestor_id')->index();
            $table->unsignedBigInteger('descendant_id')->index();
            $table->unsignedInteger('depth')->default(0)->index();
            $table->enum('tree_type', ['sponsor', 'placement'])->index();

            $table->foreign('company_id')->references('id')->on('companies')->onDelete('cascade');
            $table->foreign('ancestor_id')->references('id')->on('users')->onDelete('cascade');
            $table->foreign('descendant_id')->references('id')->on('users')->onDelete('cascade');
            $table->unique(['company_id', 'ancestor_id', 'descendant_id', 'tree_type']);
            $table->index(['company_id', 'ancestor_id', 'tree_type']);
            $table->index(['company_id', 'descendant_id', 'tree_type']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('closure_trees');
    }
};
