<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('placement_relations', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('company_id')->index();
            $table->unsignedBigInteger('member_id')->unique()->index();
            $table->unsignedBigInteger('placement_sponsor_id')->nullable()->index();
            $table->enum('position', ['left', 'right', 'center'])->nullable()->index();
            $table->unsignedBigInteger('left_child_id')->nullable()->index();
            $table->unsignedBigInteger('right_child_id')->nullable()->index();
            $table->unsignedInteger('left_count')->default(0);
            $table->unsignedInteger('right_count')->default(0);
            $table->unsignedInteger('depth')->default(0)->index();
            $table->timestamps();

            $table->foreign('company_id')->references('id')->on('companies')->onDelete('cascade');
            $table->foreign('member_id')->references('id')->on('users')->onDelete('cascade');
            $table->foreign('placement_sponsor_id')->references('id')->on('users')->onDelete('set null');
            $table->foreign('left_child_id')->references('id')->on('users')->onDelete('set null');
            $table->foreign('right_child_id')->references('id')->on('users')->onDelete('set null');
            $table->unique(['company_id', 'member_id']);
            $table->index(['company_id', 'placement_sponsor_id']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('placement_relations');
    }
};
