<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('sponsor_relations', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('company_id')->index();
            $table->unsignedBigInteger('member_id')->unique()->index();
            $table->unsignedBigInteger('sponsor_id')->nullable()->index();
            $table->unsignedInteger('depth')->default(0)->index();
            $table->timestamp('joined_at')->nullable();
            $table->timestamps();

            $table->foreign('company_id')->references('id')->on('companies')->onDelete('cascade');
            $table->foreign('member_id')->references('id')->on('users')->onDelete('cascade');
            $table->foreign('sponsor_id')->references('id')->on('users')->onDelete('set null');
            $table->unique(['company_id', 'member_id']);
            $table->index(['company_id', 'sponsor_id']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('sponsor_relations');
    }
};
