<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('transactions', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('company_id')->index();
            $table->string('transaction_key')->unique()->index();
            $table->unsignedBigInteger('user_id')->nullable()->index();
            $table->enum('type', [
                'income', 'commission', 'bonus', 'roi', 'payout', 
                'recharge', 'repurchase', 'withdrawal', 'refund', 'adjustment'
            ])->index();
            $table->enum('status', [
                'pending', 'processed', 'failed', 'cancelled', 'reversed'
            ])->default('pending')->index();
            $table->decimal('amount', 18, 2)->index();
            $table->decimal('fees', 18, 2)->default(0);
            $table->decimal('net_amount', 18, 2);
            $table->text('description')->nullable();
            $table->unsignedBigInteger('created_by')->nullable();
            $table->timestamp('processed_at')->nullable();
            $table->unsignedBigInteger('processed_by')->nullable();
            $table->string('reference_id')->nullable()->unique();
            $table->timestamps();

            $table->foreign('company_id')->references('id')->on('companies')->onDelete('cascade');
            $table->foreign('user_id')->references('id')->on('users')->onDelete('set null');
            $table->foreign('created_by')->references('id')->on('users')->onDelete('set null');
            $table->foreign('processed_by')->references('id')->on('users')->onDelete('set null');
            $table->index(['company_id', 'user_id', 'status']);
            $table->index(['created_at']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('transactions');
    }
};
