<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('wallets', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('company_id')->index();
            $table->unsignedBigInteger('user_id')->index();
            $table->enum('type', [
                'income', 'recharge', 'repurchase', 'shopping', 
                'roi', 'bonus', 'withdrawal', 'holding'
            ])->index();
            $table->decimal('balance', 18, 2)->default(0)->index();
            $table->decimal('locked_balance', 18, 2)->default(0);
            $table->decimal('total_credited', 18, 2)->default(0);
            $table->decimal('total_debited', 18, 2)->default(0);
            $table->timestamp('last_updated_at')->nullable();
            $table->timestamps();

            $table->foreign('company_id')->references('id')->on('companies')->onDelete('cascade');
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
            $table->unique(['company_id', 'user_id', 'type']);
            $table->index(['company_id', 'user_id']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('wallets');
    }
};
