<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('users', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('company_id')->index();
            $table->string('first_name');
            $table->string('last_name');
            $table->string('email')->unique();
            $table->string('phone')->unique();
            $table->string('username')->unique()->index();
            $table->timestamp('email_verified_at')->nullable();
            $table->string('password');
            $table->string('referral_code')->unique()->index();
            $table->enum('user_type', ['distributor', 'franchisee', 'customer'])->default('customer')->index();
            $table->enum('status', ['active', 'inactive', 'suspended', 'blocked'])->default('inactive')->index();
            $table->timestamp('activated_at')->nullable();
            $table->timestamp('deactivated_at')->nullable();
            $table->string('registration_ip')->nullable();
            $table->string('device_fingerprint')->nullable();
            $table->text('address')->nullable();
            $table->string('city')->nullable();
            $table->string('state')->nullable();
            $table->string('country')->nullable();
            $table->string('zip')->nullable();
            $table->string('pan')->nullable();
            $table->string('aadhar')->nullable();
            $table->string('bank_account_name')->nullable();
            $table->string('bank_account_number')->nullable();
            $table->string('bank_ifsc')->nullable();
            $table->string('upi_id')->nullable();
            $table->decimal('tds_percentage', 5, 2)->default(0);
            $table->boolean('kyc_verified')->default(false)->index();
            $table->timestamp('kyc_verified_at')->nullable();
            $table->boolean('is_leader')->default(false)->index();
            $table->string('rank')->nullable()->index();
            $table->timestamp('rank_achieved_at')->nullable();
            $table->boolean('is_blocked')->default(false)->index();
            $table->string('blocked_reason')->nullable();
            $table->timestamp('blocked_at')->nullable();
            $table->unsignedBigInteger('blocked_by')->nullable();
            $table->string('remember_token')->nullable();
            $table->timestamps();
            $table->softDeletes();

            $table->foreign('company_id')->references('id')->on('companies')->onDelete('cascade');
            $table->foreign('blocked_by')->references('id')->on('users')->onDelete('set null');
            $table->index(['company_id', 'status']);
            $table->index(['company_id', 'user_type']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('users');
    }
};
