<?php

namespace App\Services;

use App\Models\SponsorRelation;
use App\Models\PlacementRelation;
use App\Models\ClosureTree;
use App\Models\User;
use Illuminate\Support\Facades\DB;

class TreeEngine
{
    /**
     * Place a user in the genealogy tree.
     */
    public static function placeUser($companyId, $userId, $sponsorId, $placementSponsorId, $position = null)
    {
        DB::transaction(function () use ($companyId, $userId, $sponsorId, $placementSponsorId, $position) {
            SponsorRelation::create([
                'company_id' => $companyId,
                'member_id' => $userId,
                'sponsor_id' => $sponsorId,
                'depth' => 0,
                'joined_at' => now(),
            ]);
            PlacementRelation::create([
                'company_id' => $companyId,
                'member_id' => $userId,
                'placement_sponsor_id' => $placementSponsorId,
                'position' => $position,
                'depth' => 0,
            ]);
            // Closure table for fast ancestor/descendant queries
            ClosureTree::create([
                'company_id' => $companyId,
                'ancestor_id' => $userId,
                'descendant_id' => $userId,
                'depth' => 0,
                'tree_type' => 'sponsor',
            ]);
            ClosureTree::create([
                'company_id' => $companyId,
                'ancestor_id' => $userId,
                'descendant_id' => $userId,
                'depth' => 0,
                'tree_type' => 'placement',
            ]);
        });
    }

    /**
     * Get upline (ancestors) for a user in O(log n) time.
     */
    public static function getUpline($companyId, $userId, $treeType = 'sponsor')
    {
        return ClosureTree::where('company_id', $companyId)
            ->where('descendant_id', $userId)
            ->where('tree_type', $treeType)
            ->where('depth', '>', 0)
            ->orderBy('depth')
            ->get();
    }

    /**
     * Get downline (descendants) for a user in O(log n) time.
     */
    public static function getDownline($companyId, $userId, $treeType = 'sponsor')
    {
        return ClosureTree::where('company_id', $companyId)
            ->where('ancestor_id', $userId)
            ->where('tree_type', $treeType)
            ->where('depth', '>', 0)
            ->orderBy('depth')
            ->get();
    }
}
