<?php

namespace App\Services;

use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Log;

class NotificationService
{
    public function sendEmail($to, $subject, $body)
    {
        Mail::raw($body, function ($message) use ($to, $subject) {
            $message->to($to)->subject($subject);
        });
    }

    public function sendSMS($to, $message)
    {
        // Integrate with SMS provider (Twilio, Nexmo, etc.)
        Log::info("SMS to $to: $message");
    }

    public function sendWhatsApp($to, $message)
    {
        // Integrate with WhatsApp provider (Twilio, etc.)
        Log::info("WhatsApp to $to: $message");
    }
}
