<?php

namespace App\Services\Compensation;

use App\Models\User;
use App\Services\LedgerEngine;

class UnilevelPlanService
{
    /**
     * Process unilevel income for a user.
     */
    public function processUnilevel(User $user, $date)
    {
        // Example: Calculate unilevel income
        // Write to ledger (never credit wallet directly)
        LedgerEngine::transact(
            [/* debit accounts */],
            [/* credit accounts */],
            [
                'company_id' => $user->company_id,
                'user_id' => $user->id,
                'type' => 'unilevel',
                'description' => 'Unilevel Income',
            ],
            'unilevel_'.$user->id.'_'.$date
        );
        return true;
    }
}
