<?php

namespace App\Services\Compensation;

use App\Models\User;
use App\Services\LedgerEngine;

class DirectIncomeService
{
    public function processDirect(User $user, $date)
    {
        // Direct income logic
        LedgerEngine::transact(
            [/* debit accounts */],
            [/* credit accounts */],
            [
                'company_id' => $user->company_id,
                'user_id' => $user->id,
                'type' => 'direct',
                'description' => 'Direct Income',
            ],
            'direct_'.$user->id.'_'.$date
        );
        return true;
    }
}
