<?php

namespace App\Services\Compensation;

use App\Models\User;
use App\Models\BVRecord;
use App\Services\LedgerEngine;

class BinaryPlanService
{
    /**
     * Process binary pairing income for a user.
     */
    public function processPairing(User $user, $date)
    {
        // Example: Calculate left/right BV, capping, ratio, etc.
        $bv = BVRecord::where('user_id', $user->id)->where('record_date', $date)->first();
        if (!$bv) return false;
        $pair = min($bv->left_bv, $bv->right_bv);
        if ($pair <= 0) return false;
        // Capping logic, ratio, etc. can be added here
        // Write to ledger (never credit wallet directly)
        LedgerEngine::transact(
            [/* debit accounts */],
            [/* credit accounts */],
            [
                'company_id' => $user->company_id,
                'user_id' => $user->id,
                'type' => 'binary_pairing',
                'description' => 'Binary Pairing Income',
            ],
            'binary_'.$user->id.'_'.$date
        );
        return true;
    }
}
