<?php
namespace App\Services;

use App\Models\User;
use App\Models\Order;

class BinaryBVService
{
    public function calculateBV(User $user)
    {
        $leftBV = $this->getSideBV($user, 'left');
        $rightBV = $this->getSideBV($user, 'right');
        $pairBV = min($leftBV, $rightBV);
        return [
            'left' => $leftBV,
            'right' => $rightBV,
            'pair' => $pairBV,
        ];
    }

    public function getSideBV(User $user, $side)
    {
        // Find all users in the given side
        $sideUsers = User::where('sponsor_id', $user->id)->where('side', $side)->pluck('id');
        // Sum BV from orders of those users
        $bv = Order::whereIn('user_id', $sideUsers)->sum('bv');
        return $bv;
    }
}
