<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;

class User extends Authenticatable
{
    use Notifiable, SoftDeletes;

    protected $fillable = [
        'company_id', 'first_name', 'last_name', 'email', 'phone', 'username', 'password', 'referral_code',
        'user_type', 'status', 'activated_at', 'deactivated_at', 'registration_ip', 'device_fingerprint',
        'address', 'city', 'state', 'country', 'zip', 'pan', 'aadhar', 'bank_account_name',
        'bank_account_number', 'bank_ifsc', 'upi_id', 'tds_percentage', 'kyc_verified', 'kyc_verified_at',
        'is_leader', 'rank', 'rank_achieved_at', 'is_blocked', 'blocked_reason', 'blocked_at', 'blocked_by',
        'remember_token'
    ];

    protected $hidden = ['password', 'remember_token'];
    protected $casts = [
        'activated_at' => 'datetime',
        'deactivated_at' => 'datetime',
        'kyc_verified' => 'boolean',
        'kyc_verified_at' => 'datetime',
        'is_leader' => 'boolean',
        'is_blocked' => 'boolean',
        'blocked_at' => 'datetime',
        'rank_achieved_at' => 'datetime',
    ];

    public function company() { return $this->belongsTo(Company::class); }
}
