<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Transaction extends Model
{
    protected $fillable = [
        'company_id', 'transaction_key', 'user_id', 'type', 'status', 'amount', 'fees', 'net_amount', 'description',
        'created_by', 'processed_at', 'processed_by', 'reference_id'
    ];
    public function company() { return $this->belongsTo(Company::class); }
    public function user() { return $this->belongsTo(User::class); }
}
