<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class SponsorRelation extends Model
{
    protected $fillable = [
        'company_id', 'member_id', 'sponsor_id', 'depth', 'joined_at'
    ];
    public function company() { return $this->belongsTo(Company::class); }
    public function member() { return $this->belongsTo(User::class, 'member_id'); }
    public function sponsor() { return $this->belongsTo(User::class, 'sponsor_id'); }
}
