<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class PlacementRelation extends Model
{
    protected $fillable = [
        'company_id', 'member_id', 'placement_sponsor_id', 'position', 'left_child_id', 'right_child_id', 'left_count', 'right_count', 'depth'
    ];
    public function company() { return $this->belongsTo(Company::class); }
    public function member() { return $this->belongsTo(User::class, 'member_id'); }
    public function placementSponsor() { return $this->belongsTo(User::class, 'placement_sponsor_id'); }
}
