<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Order extends Model
{
    protected $fillable = [
        'company_id', 'user_id', 'total', 'status', 'payment_method', 'shipping_address', 'billing_address', 'notes'
    ];
    public function user() { return $this->belongsTo(User::class); }
    public function company() { return $this->belongsTo(Company::class); }
    public function items() { return $this->hasMany(OrderItem::class); }
}
