<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class LedgerEntry extends Model
{
    protected $fillable = [
        'company_id', 'transaction_id', 'account_id', 'user_id', 'entry_type', 'amount', 'entry_code', 'description', 'posted_at'
    ];
    public function company() { return $this->belongsTo(Company::class); }
    public function transaction() { return $this->belongsTo(Transaction::class); }
    public function account() { return $this->belongsTo(Account::class); }
}
