<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Company extends Model
{
    use SoftDeletes;

    protected $fillable = [
        'name', 'slug', 'email', 'phone', 'website', 'address', 'city', 'state', 'country', 'zip',
        'gst_number', 'tan_number', 'pan_number', 'bank_account_name', 'bank_account_number', 'bank_ifsc',
        'currency', 'timezone', 'settings', 'is_active', 'verified_at'
    ];

    protected $casts = [
        'settings' => 'array',
        'is_active' => 'boolean',
        'verified_at' => 'datetime',
    ];

    public function users() { return $this->hasMany(User::class); }
}
