<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ClosureTree extends Model
{
    protected $fillable = [
        'company_id', 'ancestor_id', 'descendant_id', 'depth', 'tree_type'
    ];
    public function company() { return $this->belongsTo(Company::class); }
    public function ancestor() { return $this->belongsTo(User::class, 'ancestor_id'); }
    public function descendant() { return $this->belongsTo(User::class, 'descendant_id'); }
}
