<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\TwoFactorAuthentication;

class TwoFactorAuth
{
    public function handle(Request $request, Closure $next)
    {
        if (Auth::check()) {
            $user = Auth::user();
            $tfa = TwoFactorAuthentication::where('user_id', $user->id)->first();
            if ($tfa && $tfa->is_enabled && !$request->session()->get('2fa_passed')) {
                return redirect('/2fa');
            }
        }
        return $next($request);
    }
}
