<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\Company;

class TenantIsolation
{
    public function handle(Request $request, Closure $next)
    {
        $companyId = null;
        if (Auth::check()) {
            $companyId = Auth::user()->company_id;
        } elseif ($request->has('company_id')) {
            $companyId = $request->input('company_id');
        }
        if ($companyId) {
            app()->instance('company_id', $companyId);
        }
        return $next($request);
    }
}
