<?php

namespace App\Http\Controllers;

use App\Models\WithdrawalRequest;
use App\Models\Wallet;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class WithdrawalController extends Controller
{
    public function index(Request $request)
    {
        $companyId = Auth::user()->company_id;
        $requests = WithdrawalRequest::where('company_id', $companyId)
            ->orderByDesc('created_at')
            ->paginate(20);
        return view('withdrawal.index', compact('requests'));
    }

    public function create()
    {
        $wallets = Wallet::where('user_id', Auth::id())->get();
        return view('withdrawal.create', compact('wallets'));
    }

    public function store(Request $request)
    {
        $data = $request->validate([
            'wallet_id' => 'required|exists:wallets,id',
            'amount' => 'required|numeric|min:1',
        ]);
        $data['user_id'] = Auth::id();
        $data['company_id'] = Auth::user()->company_id;
        $data['status'] = 'pending';
        WithdrawalRequest::create($data);
        return redirect()->route('withdrawal.index')->with('success', 'Withdrawal request submitted.');
    }

    public function edit(WithdrawalRequest $withdrawal)
    {
        return view('withdrawal.edit', compact('withdrawal'));
    }

    public function update(Request $request, WithdrawalRequest $withdrawal)
    {
        $data = $request->validate([
            'status' => 'required|string',
        ]);
        $withdrawal->update($data);
        return redirect()->route('withdrawal.index')->with('success', 'Withdrawal status updated.');
    }

    public function destroy(WithdrawalRequest $withdrawal)
    {
        $withdrawal->delete();
        return redirect()->route('withdrawal.index')->with('success', 'Withdrawal request deleted.');
    }
}
