<?php

namespace App\Http\Controllers;

use App\Models\IncomeRecord;
use App\Models\Wallet;
use App\Models\Transaction;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class ReportController extends Controller
{
    public function income(Request $request)
    {
        $companyId = Auth::user()->company_id;
        $records = IncomeRecord::where('company_id', $companyId)
            ->orderByDesc('created_at')
            ->paginate(20);
        return view('report.income', compact('records'));
    }

    public function commission(Request $request)
    {
        $companyId = Auth::user()->company_id;
        $records = IncomeRecord::where('company_id', $companyId)
            ->where('type', 'commission')
            ->orderByDesc('created_at')
            ->paginate(20);
        return view('report.commission', compact('records'));
    }

    public function payout(Request $request)
    {
        $companyId = Auth::user()->company_id;
        $wallets = Wallet::where('company_id', $companyId)->get();
        $transactions = Transaction::where('company_id', $companyId)
            ->where('type', 'payout')
            ->orderByDesc('created_at')
            ->paginate(20);
        return view('report.payout', compact('wallets', 'transactions'));
    }
}
