<?php

namespace App\Http\Controllers;

use App\Models\Role;
use App\Models\Permission;
use App\Models\User;
use Illuminate\Http\Request;

class RBACController extends Controller
{
    public function roles()
    {
        $roles = Role::all();
        return view('rbac.roles', compact('roles'));
    }

    public function permissions()
    {
        $permissions = Permission::all();
        return view('rbac.permissions', compact('permissions'));
    }

    public function assignRole(Request $request)
    {
        $data = $request->validate([
            'user_id' => 'required|exists:users,id',
            'role_id' => 'required|exists:roles,id',
        ]);
        $user = User::find($data['user_id']);
        $user->roles()->syncWithoutDetaching([$data['role_id']]);
        return back()->with('success', 'Role assigned.');
    }

    public function assignPermission(Request $request)
    {
        $data = $request->validate([
            'role_id' => 'required|exists:roles,id',
            'permission_id' => 'required|exists:permissions,id',
        ]);
        $role = Role::find($data['role_id']);
        $role->permissions()->syncWithoutDetaching([$data['permission_id']]);
        return back()->with('success', 'Permission assigned.');
    }
}
