<?php

namespace App\Http\Controllers;

use App\Models\Product;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;

class ProductController extends Controller
{
    public function index()
    {
        $products = \Cache::remember('products.all', 60, function() {
            return Product::all();
        });
        return view('products.index', compact('products'));
    }

    public function show($id)
    {
        $product = \Cache::remember('product.' . $id, 60, function() use ($id) {
            return Product::findOrFail($id);
        });
        return view('products.show', compact('product'));
    }
}
