<?php

namespace App\Http\Controllers;

use App\Models\Order;
use App\Models\OrderItem;
use App\Models\Cart;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Routing\Controller;

class OrderController extends Controller
{
    public function index()
    {
        $orders = Order::where('user_id', Auth::id())->with('items.product')->get();
        return view('order.index', compact('orders'));
    }

    public function store(Request $request)
    {
        $cartItems = Cart::where('user_id', Auth::id())->get();
        if ($cartItems->isEmpty()) {
            return redirect()->route('cart.index')->with('error', 'Cart is empty.');
        }
        $order = Order::create([
            'company_id' => Auth::user()->company_id,
            'user_id' => Auth::id(),
            'total' => $cartItems->sum(fn($item) => $item->product->sale_price * $item->quantity),
            'status' => 'pending',
            'payment_method' => 'manual',
        ]);
        foreach ($cartItems as $item) {
            OrderItem::create([
                'order_id' => $order->id,
                'product_id' => $item->product_id,
                'quantity' => $item->quantity,
                'price' => $item->product->sale_price,
                'total' => $item->product->sale_price * $item->quantity,
            ]);
            $item->delete();
        }
        return redirect()->route('order.index')->with('success', 'Order placed successfully.');
    }
}
