<?php

namespace App\Http\Controllers;

use App\Services\NotificationService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class NotificationController extends Controller
{
    public function send(Request $request)
    {
        $data = $request->validate([
            'type' => 'required|string',
            'to' => 'required|string',
            'subject' => 'nullable|string',
            'message' => 'required|string',
        ]);
        $service = new NotificationService();
        switch ($data['type']) {
            case 'email':
                $service->sendEmail($data['to'], $data['subject'], $data['message']);
                break;
            case 'sms':
                $service->sendSMS($data['to'], $data['message']);
                break;
            case 'whatsapp':
                $service->sendWhatsApp($data['to'], $data['message']);
                break;
        }
        return back()->with('success', 'Notification sent.');
    }

    public function form()
    {
        return view('notification.form');
    }
}
